<?php
defined('PF_VERSION') OR exit('Access denied');
/**
 * 
 * @author vudoanthang
 *
 */
abstract class Pf_Plugin {
    public $name;
    public $version;
    public $author;
    public $description;
    
    /**
     * Activate plugin
     */
    public function activate() {
    }
    /**
     * Deactive plugin
     */
    public function deactivate() {
    }
    /**
     * This method is executed when public page is loaded
     */
    public function public_init() {
    }
    /**
     * This method is executed when admin page is loaded
     */
    public function admin_init() {
    }
    /**
     *
     * @param unknown $icon_class            
     * @param unknown $name            
     * @param string $callback            
     */
    protected function admin_menu($icon_class, $name, $key, $callback) {
        admin_menu ( get_class ( $this ), $icon_class, $name, $key, $callback );
    }
    /**
     *
     * @param unknown $icon_class            
     * @param unknown $name            
     * @param unknown $callback            
     * @param unknown $parent            
     */
    protected function admin_children_menu($icon_class, $name, $key, $callback, $parent) {
        admin_menu ( get_class ( $this ), $icon_class, $name, $key, $callback, $parent );
    }
    /**
     * 
     * @param unknown $link
     * @param string $file
     */
    protected function css($link, $file = '') {
        if (is_array($link)){
            foreach ($link as $v){
                if (is_string($v) && !empty($v)){
                    admin_css ( $v, $file );
                }
            }
        }else if (is_string($link) && !empty($link)){
            admin_css ( $link, $file );
        }
    }
    /**
     * 
     * @param unknown $js
     * @param string $file
     */
    protected function js($js, $file = ''){
        if (is_array($js)){
            foreach ($js as $v){
                if (is_string($v) && !empty($v)){
                    admin_js($v, $file);
                }
            }
        }else if (is_string($js) && !empty($js)){
            admin_js($js, $file);
        }
    }
}